

PD_CompScans_AlltoAll <- function(datafA,dataf){

  
  datafA$Unique_scan <- paste0(datafA$Spectrum.File,"_",datafA$First.Scan)
  dataf$Unique_scan <- paste0(dataf$Spectrum.File,"_",dataf$First.Scan)
  datafA$PTM_final_prob <- (1-datafA$PEP)*datafA$ptmRS_Score/100
  dataf$PTM_final_prob <- (1-dataf$PEP)*dataf$ptmRS_Score/100
  datafA$Amino <- str_sub(substr(datafA$Sequence,1,datafA$PTM_Positions),-1)
  dataf$Amino <- str_sub(substr(dataf$Sequence,1,dataf$PTM_Positions),-1)
  

ReduceddatafA <- subset(datafA,select = c(Unique_scan,Sequence,Amino,PTM_final_prob, PTM_Positions, PEP, ptmRS_Score))

ReduceddatafA <- ReduceddatafA %>% dplyr::rename(
  pASTY_Score = PTM_final_prob,
  pASTY_PEP = PEP,
  pASTY_PTMprob = ptmRS_Score
)
Reduceddataf <- subset(dataf,select = c(Unique_scan,Sequence,PTM_final_prob, PTM_Positions, PEP, ptmRS_Score))

Reduceddataf <- Reduceddataf %>% dplyr::rename(
  SequenceSTY = Sequence,
  PTM_PositionsSTY= PTM_Positions,
  pSTY_Score = PTM_final_prob,
  pSTY_PEP = PEP,
  pSTY_PTMprob = ptmRS_Score
)


dataf_Merged <- merge(x=ReduceddatafA,y=Reduceddataf,by="Unique_scan", all = TRUE)
#dataf_Merged<- dataf_Merged %>% group_by(Unique_scan) %>% dplyr::mutate(count_S = n())
#dataf_Merged<- dataf_Merged %>% group_by(Unique_scan) %>% dplyr::mutate(count_M = n_distinct(PTM_Positions))


#dataf_Merged$SeqMatch <- ifelse(dataf_Merged$Sequence==dataf_Merged$SequenceSTY,1,0)
#dataf_Merged$PTM_Match <- ifelse(dataf_Merged$Sequence==dataf_Merged$SequenceSTY&dataf_Merged$PTM_Positions==dataf_Merged$PTM_PositionsSTY,1,0)
#dataf_Merged$SiteID <- paste0(dataf_Merged$Unique_scan,"_", dataf_Merged$PTM_Positions)
#dataf_Merged <- dataf_Merged %>% distinct(SiteID, .keep_all = TRUE)
return(dataf_Merged)

}
